package gov.va.vinci.dart.biz;

import java.util.List;

import gov.va.vinci.dart.common.ValidationHelper;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.dms.biz.Document;
import gov.va.vinci.dart.service.DartObjectFactory;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Entity
@Table(name="requestadminparticipantdocument", schema="hib")
public class RequestAdminParticipantDocument {
	private static Log log = LogFactory.getLog(RequestAdminParticipantDocument.class);
	
	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY) // because of course SQL Server doesn't support sequences.
	private int id;
	
	@Column(name="requestid")
	private int requestId;
	
	@Column(name="participantid")
	private int participantId;
	
	@Column(name="documentid")
	private int documentId;

	@Column(name="groupid")
	private int groupId;
	
	@Column(name="active", columnDefinition = "BIT", length = 1)
	private boolean active;

	RequestAdminParticipantDocument() {}
	
	public static RequestAdminParticipantDocument create(Request request, Participant participant, Document document, Group reviewer) throws ValidationException {
		ValidationHelper.required("Request", request);
		ValidationHelper.required("Participant", participant);
		ValidationHelper.required("Document", document);
		ValidationHelper.required("Reviewer", reviewer);
	
		RequestAdminParticipantDocument result = new RequestAdminParticipantDocument();
		result.requestId = request.getId();
		result.participantId = participant.getId();
		result.documentId = document.getId();
		result.groupId = reviewer.getId();
		result.active = true;

		DartObjectFactory.getInstance().getRequestAdminParticipantDocumentDAO().save(result);
		return result;
	}
	
	public static List<RequestAdminParticipantDocument> listByRequestId(final int requestId) {
		return DartObjectFactory.getInstance().getRequestAdminParticipantDocumentDAO().listByRequestId(requestId);
	}

	public static List<RequestAdminParticipantDocument> listByDocumentId(final int documentId) {
		return DartObjectFactory.getInstance().getRequestAdminParticipantDocumentDAO().listByDocumentId(documentId);
	}
	
	public static List<RequestAdminParticipantDocument> listByRequestIdAndGroupId(final int requestId, final int groupId) {
		return DartObjectFactory.getInstance().getRequestAdminParticipantDocumentDAO().listByRequestIdAndGroupId(requestId, groupId);
	}	
	
	public void delete() {
		log.debug("Deleting request admin location document");
		DartObjectFactory.getInstance().getRequestAdminParticipantDocumentDAO().delete(this);
	}
	
	public int getId() {
		return id;
	}
	
	// TESTING ONLY
	public void setId(int id) {
		this.id = id;
	}
	
	public int getRequestId() {
		return requestId;
	}

	public int getParticipantId() {
		return participantId;
	}

	public int getDocumentId() {
		return documentId;
	}

	public int getGroupId() {
		return groupId;
	}
	
	public boolean isActive() {
		return active;
	}

	public void setActive(boolean active) {
		this.active = active;
	}
}
